-- Title: Vježbe 8 - Helper

-- USE AdventureWorksOBP
USE AdventureWorksOBP

/* --------------------------------------------------------------------- */
-- Vježbe: 8
/* --------------------------------------------------------------------- */

/*
Prezentacija: OBP-Vjez-08.pptx
Slajd: 2
Zadatak: 1
*/

-- SELECT Racun WHERE KupacID = 378
SELECT BrojRacuna, DatumIzdavanja FROM Racun WHERE KupacID = 378

-- CAST DatumIzdavanja
SELECT BrojRacuna, CAST(DatumIzdavanja AS char(10)) AS DatumIzdavanja
FROM Racun WHERE KupacID = 378

-- COVERT DatumIzdavanja
SELECT BrojRacuna, CONVERT(char(10), DatumIzdavanja, 104) AS DatumIzdavanja
FROM Racun WHERE KupacID = 378

/* ---------- */

/*
Prezentacija: OBP-Vjez-08.pptx
Slajd: 3
Zadatak: 4
*/

-- Korištenje: CASE
SELECT 
	p.Naziv,
	CASE
		WHEN pk.Naziv IS NULL THEN 'Nije definirana'
		ELSE pk.Naziv
	END AS NazivPotkategorije
FROM Proizvod AS p
LEFT JOIN Potkategorija AS pk ON p.PotkategorijaID = pk.IDPotkategorija

/* ---------- */

/*
Prezentacija: OBP-Vjez-08.pptx
Slajd: 3
Zadatak: 6
*/

-- Kreiranje tablice: Proba
CREATE TABLE Proba ( IDProba int PRIMARY KEY IDENTITY, Vrijednost int)
GO

-- While
DECLARE @i int = 10000
WHILE @i <= 12000 BEGIN
	INSERT INTO Proba VALUES (@i)
	SET @i += 1
END

SELECT * FROM Proba
GO

/* ---------- */

/*
Prezentacija: OBP-Vjez-08.pptx
Slajd: 7
Zadatak: 8
*/

-- Tablica: Zivotinja
CREATE TABLE Zivotinja 
(
	IDZivotinja int PRIMARY KEY,
	Naziv nvarchar(50)
)
GO

-- Procedura: InsertanjeZivotinja
CREATE PROC spInsertZivotinja 
	@IDZivotinja int,
	@Naziv nvarchar(50)
AS
INSERT INTO Zivotinja (IDZivotinja, Naziv) VALUES (@IDZivotinja, @Naziv)
GO

-- Problem:
EXEC spInsertZivotinja 20, 'Roda'
EXEC spInsertZivotinja 20, 'Roda'

--
-- Solution 1: Vanjski blok TRY-CATCH
--
BEGIN TRY
	EXEC spInsertZivotinja 20, 'Roda'
	EXEC spInsertZivotinja 20, 'Roda'
END TRY
BEGIN CATCH
	PRINT 'Error message: ' + cast(ERROR_MESSAGE() as NVARCHAR(100))
	PRINT 'Error number: ' + cast(ERROR_NUMBER() as NVARCHAR(100))
	PRINT 'Error severity: ' + cast(ERROR_SEVERITY() as NVARCHAR(100))
	PRINT 'Error line ' + cast(ERROR_LINE() as NVARCHAR(100))
	PRINT 'Error procedure: ' + cast(ERROR_PROCEDURE() as NVARCHAR(100))
END CATCH
GO

--
-- Solution 2: InsertanjeZivotinja
--
ALTER PROC spInsertZivotinja 
	@IDZivotinja int,
	@Naziv nvarchar(50)
AS
BEGIN TRY
	INSERT INTO Zivotinja (IDZivotinja, Naziv) VALUES (@IDZivotinja, @Naziv)
END TRY
BEGIN CATCH
	PRINT 'Desila se greška: ' + ERROR_MESSAGE()
	PRINT 'Životinja nije upisana.'
END CATCH
GO

EXEC spInsertZivotinja 20, 'Roda'

/*
Prezentacija: OBP-Vjez-08.pptx
Slajd: 9
Zadatak: Naš zadatak
*/

-- Create: Kupac
CREATE PROC spInsertKupac
	@IDKupac INT OUTPUT, 
	@Ime NVARCHAR(50), 
	@Prezime NVARCHAR(50)
AS
INSERT INTO Kupac (Ime, Prezime) VALUES (@Ime, @Prezime)
SET @IDKupac = SCOPE_IDENTITY()
GO

-- Retrieve: Kupac
CREATE PROC spGetKupac
	@IDKupac int
AS
SELECT * FROM Kupac WHERE IDKupac = @IDKupac
GO

-- Update: Kupac
CREATE PROC spUpdateKupac
	@IDKupac INT, 
	@Ime NVARCHAR(50), 
	@Prezime NVARCHAR(50)
AS
UPDATE Kupac SET Ime = @Ime, Prezime = @Prezime
WHERE IDKupac = @IDKupac
GO

-- Delete: Kupac
CREATE PROC spDeleteKupac
	@IDKupac INT
AS
DELETE FROM Kupac WHERE IDKupac = @IDKupac
GO

-- EXEC
-- C
DECLARE @NoviIDKupac int
EXEC spInsertKupac @IDKupac = @NoviIDKupac OUTPUT, 
@Ime = 'Ana', @Prezime = 'Anić'
PRINT @NoviIDKupac
-- R
EXEC spGetKupac <IDKUPAC>
-- U
EXEC spUpdateKupac <IDKUPAC>, 'Ana Marija', 'Anić'
-- D
EXEC spDeleteKupac <IDKUPAC>

-- CRUD Procedure: CRUDKupac
CREATE PROCEDURE spCRUDKupac
	@_What CHAR,
	@_IDKupac INT = NULL,
	@_Ime NVARCHAR(50) = NULL, 
	@_Prezime NVARCHAR(50) = NULL
AS 
	BEGIN TRY
		IF(@_What = 'C')
			BEGIN
				DECLARE @NoviIDKupac int
				EXEC spInsertKupac @IDKupac = @NoviIDKupac OUTPUT, 
				@Ime = @_Ime, @Prezime = @_Prezime
				PRINT @NoviIDKupac
			END
		ELSE IF (@_What = 'R')
			BEGIN
				EXEC spGetKupac @_IDKupac
			END
		ELSE IF (@_What = 'U')
			BEGIN
				EXEC spUpdateKupac @_IDKupac, @_Ime, @_Prezime
			END
		ELSE IF (@_What = 'D')
			BEGIN
				EXEC spDeleteKupac @_IDKupac
			END
		ELSE 
			BEGIN
				PRINT 'Poslali ste parametar koji ne postoji!'
			END
	END TRY
	BEGIN CATCH
		PRINT 'Desila se greška: ' + ERROR_MESSAGE()
	END CATCH
	GO
	
EXEC spCRUDKupac 'C', @_Ime='Pero', @_Prezime='Peric'
EXEC spCRUDKupac 'R', @_IDKupac=<IDKUPAC>
EXEC spCRUDKupac 'U',  @_IDKupac=<IDKUPAC>, 
@_Ime='Pero Perica', @_Prezime='Peric'

EXEC spCRUDKupac 'R', @_IDKupac=<IDKUPAC>
EXEC spCRUDKupac 'D',  @_IDKupac=<IDKUPAC>
EXEC spCRUDKupac 'M',  @_IDKupac=<IDKUPAC>
EXEC spCRUDKupac 'D',  @_IDKupac=1

/* --------------------------------------------------------------------- */
-- Ponavljanje
/* --------------------------------------------------------------------- */

/*
ZADATAK 1 [POGLEDI]:
Napravite pogled koji prikazuje države i broj kupaca iz svake države. Pogled treba vratiti stupce: NazivDrzave i BrojKupaca. 
Iskoristite pogled za dohvaćanje države s najviše kupaca. Napišite naredbu za uklanjanje pogleda.
*/

/* 
ZADATAK 2 [POGLEDI]:
Napravite pogled koji vraća formatiran datum na hrvatski način te broj proizvoda koji su prodani u tom razdoblju. 
Iskoristite pogled za dohvaćanje 3 mjeseca s najvećom prodajom proizvoda. Osmislite dodatne mjere kako biste zaštitili
definiciju od neovlaštenog pregleda sadržaja pogleda. Napišite naredbu za uklanjanje pogleda.
*/

/*
ZADATAK 3 [OKIDAČI]:
Napravite novu tablicu Zapisnik sa stupcima IDZapisnik, Poruka i Vrijeme. Napravite okidač na tablici Grad koji će pri
svakom događaju INSERT, UPDATE ili DELETE upisati novi zapis s odgovoarajućom porukom i vremenom u tablicu Zapisnik.
Napišite naredbu za uklanjanje okidača.
Primjer poruka:
- INSERT: Grad je dodan u tablicu.
- UPDATE: Grad je ažuriran u tablici.
- DELETE: Grad je obrisan iz tablice.
*/

/*
ZADATAK 4 [ANALIZA PODATAKA NA DISKU]:
Analizirajte tablicu Kupac i odgovorite na sljedeća pitanja:
1. Na koliko stranica su smješteni podaci iz tablice Kupac?
2. Napišite redne brojeve prvih 5 stranica (PagePID) i redne brojeve datoteke u kojoj su smještene stranice (PageFID).
3. Na kojoj stranici se nalazi kupac s IDKupac = 35?
4. Kolika je duljina IDKupac = 10 u bajtovima?
*/

/*
ZADATAK 5 [INDEKSI]:
Optimizirajte upit što je bolje moguće:
"""
SELECT S.IDStavka, S.RacunID, S.Kolicina
FROM Stavka AS S
WHERE S.Kolicina<20 AND S.PopustUPostocima>0.2
"""
Napišite naredbu za uklanjanje indeksa.
*/

/*
ZADATAK 6 [FUNKCIJE]:
Napišite složenu tabličnu funkciju koja prima cijenu. Ako je cijena NULL, vratite nazive i cijene svih proizvoda iz tablice Proizvod. ​
Ako nije, vratite nazive i cijene samo onih proizvoda čija cijena je veća od zadane cijene. Iskoristite funkciju s NULL i s cijenom od 3000.
Uklonite funkciju.
*/

/*
ZADATAK 7 [PROCEDURE]:
Napravite procedure koje rade CRUD operacije na tablici Grad tako da operacije umetanja i izmjene obavite u jednoj proceduri, 
a druge dvije operacije obavite u posebnim procedurama. Iskoristite procedure za umetanje, izmjenu, dohvaćanje i brisanje zapisa.
Uklonite procedure.
*/

/* --------------------------------------------------------------------- */
